#include <bits/stdc++.h>
using namespace std;

string BROJ;
set<long long> proizvodi;
map<tuple<int, bool, bool, long long>, bool> memorija;

void dubinska_pretraga(int poz, bool ograniceno, bool pocelo, long long proizvod) {
    if (poz == (int)BROJ.size()) {
        if (pocelo) proizvodi.insert(proizvod);
        return;
    }

    auto stanje = make_tuple(poz, ograniceno, pocelo, proizvod);
    if (!ograniceno && memorija.count(stanje)) return;
    if (!ograniceno) memorija[stanje] = true;

    int limit = ograniceno ? (BROJ[poz] - '0') : 9;
    for (int cif = 0; cif <= limit; cif++) {
        bool novo_pocelo = pocelo || (cif != 0);
        long long novi_proizvod = proizvod;
        if (novo_pocelo) {
            if (pocelo)
                novi_proizvod *= cif;
            else
                novi_proizvod = cif;
        }
        dubinska_pretraga(poz + 1, ograniceno && cif == limit, novo_pocelo, novi_proizvod);
    }
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int BROJ_UPITA;
    cin >> BROJ_UPITA;

    while (BROJ_UPITA--) {
        cin >> BROJ;
        proizvodi.clear();
        memorija.clear();

        dubinska_pretraga(0, true, false, 1);

        cout << proizvodi.size() << '\n';
    }

    return 0;
}